// BVH Importer.js
//
// Tool script for installation ~/Library/Application Support/Cheetah3D/scripts/Tool folder
//
// How to Use.
//   1. import bone joints.
//   2. after selecting root bone joint, attach motion.
//

String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/g, '');
}

var Vec3D_toString = function( vec ) {
	return '(' + vec.x.toFixed(4) + ', ' + vec.y.toFixed(4) + ', ' + vec.z.toFixed(4) + ')';
}

//

function buildUI( tool ) {
	
    // 6.0+ version check
    if (! tool.parameterWithName) {
        OS.messageBox( "Cheetah3D version error!", "Sorry. this tool is available for Cheetah3D 6.0 above.");
        OS.beep();
        return;
    }
    
	tool.addParameterSeparator("Bone Setting");
	
    tool.addParameterFloat("scale factor", 0.1, 0, 1000, false, false);
	
	tool.addParameterSeparator("Motion Setting");
	
    tool.addParameterBool("overwrite fps", 0, 0, 1, false, false);
    tool.addParameterFloat("fps", 30, 1, 10000, false, false);
    
	tool.addParameterButton("attach motion", "attach", "attachBVHMotion");
    
	tool.addParameterSeparator("Import");
    
    tool.addParameterBool("bone only", 0, 0, 1, false, false );
    
	tool.addParameterButton("import BVH", "import", "importBVH");
    


}

function checkChunk( data, term ) {
	for ( var i = 0;i < data.length;i++ ) {
		if ( data[i] == term ) return i;
	}
	return -1;
}

function importBVH( tool ) {
    
	var path = OS.runOpenPanel("bvh");
	if (path == null) return;
	
	var file = new File(path);
	file.open(READ_MODE);

	if (file.isOpen() == false) return;
    
    curSel = importBone( tool, file );
    
    print( curSel.getParameter("name") );
    if (! tool.getParameter("bone only") ) {
        attachMotion( tool, curSel, file );
    }
    
    file.close();
}

function attachBVHMotion( tool ) {
    
    var curSel = tool.document().selectedObject();
    
    if (!curSel) {
        OS.beep();
        return;
    }
    
    var path = OS.runOpenPanel("bvh");
    if (path == null) return;
    
    var file = new File(path);
    file.open(READ_MODE);
    if (file.isOpen() == false) return;
    
    attachMotion( tool, curSel, file );
    
    file.close();
}

function importBone( tool, file ) {
	
	var doc = tool.document();
	
    file.seek( 0, SEEK_SET );
    
	var line = file.readln();
	
	var curParent;
	var curTarget;
	var curSel;
  var offset_holder = new Vec3D();
	var create_end = true; //tool.getParameter("create End Site");
	var end_toggle = false;
	var hierarchy_toggle = false;
    
    var factor = tool.getParameter("scale factor");
	
	while ( line != -1 ) {
		var data = line.trim().split(/\s+/);
		print(data);
		if (checkChunk( data, "HIERARCHY" ) > -1) {
			hierarchy_toggle = true;
		} else if (checkChunk( data, "MOTION" ) > -1) {
			hierarchy_toggle = false;
		}
		
		if (hierarchy_toggle) {
			if (checkChunk( data, "ROOT" ) > -1) {
				var index = checkChunk( data, "ROOT" );
				curTarget = doc.addObject( 45 ); // BONE
				curTarget.setParameter("name", data[index+1]);
				curTarget.setParameter("displayMode", 1);
                curSel = curTarget;
			}
			if (checkChunk( data, "JOINT" ) > -1) {
				var index = checkChunk( data, "JOINT" );
				curTarget = doc.addObject( 45 );
				curTarget.setParameter("name", data[index+1]);
				curTarget.setParameter("displayMode", 1);
				
				curParent.addChildAtIndex( curTarget, curParent.childCount() );
			}
			if (checkChunk( data, "End" ) > -1) {
				
				end_toggle = true;
				
				if (create_end) {
					curTarget = doc.addObject( 45 );
					curTarget.setParameter("name", "Site");

					curParent.addChildAtIndex( curTarget, curParent.childCount() );
				}
			}
			if (checkChunk( data, "OFFSET" ) > -1) {
				if (! end_toggle || create_end) {
					var index = checkChunk( data, "OFFSET" );
					offset_holder.x = parseFloat( data[index+1] ) * factor;
					offset_holder.y = parseFloat( data[index+2] ) * factor;
					offset_holder.z = parseFloat( data[index+3] ) * factor;
					
					curTarget.setParameter("position", offset_holder);
				}
			}
			if (checkChunk( data, "{" ) > -1) {
				if (! end_toggle || create_end) {
					curParent = curTarget;
				}
			}
			if (checkChunk( data, "}" ) > -1) {
				if (! end_toggle || create_end) {
					curParent = curParent.owner();
				} else {
					end_toggle = false;
				}
			}
		}
		
		line = file.readln();
	}
	
    return curSel;
}

var boneCache = [];
var motionList = [];

var DEG2RAD = Math.PI / 180;
var RAD2DEG = 180 / Math.PI;

function Motion(_target, _key) {
    this.target = _target;
    this.key = _key;
    this.rotationOrder = '';
}

Motion.prototype.toString = function() {
    return this.target.getParameter("name") + ':' + this.key + ' [' + this.rotationOrder + ']';
}

Array.prototype.motionWithTargetAndKey = function(target, key) {
    var index = -1;
    var len = this.length;
    for(var i = 0;i < len;i++) {
        if (this[i].target == target && this[i].key == key) {
            index = i;
        }
    }
    return index;
}

function attachMotion( tool, curSel, file ) {
	
    boneCache.length = 0;
    motionList.length = 0;
    
    cacheObjectInfo( curSel );
    
    //print('---');
    //print( boneCache.length + ':' + boneCache );
    
    file.seek( 0, SEEK_SET );
    
	var line = file.readln();
    
    var cur_index  = -1;
    var cur_name = '';
	var hierarchy_toggle = false;
    var motion_toggle = false;
    var motionCount = 0;
    var rotationHints = [];
    
    var factor = tool.getParameter("scale factor");
    
    var overwriteFps = tool.getParameter("overwrite fps");
    var fps = tool.getParameter("fps");
    
    var timeFrame = 0;
    var timeCurrent = 0;
    var currentTake = tool.document().currentTake();
    
	while ( line != -1 ) {
		var data = line.trim().split(/\s+/);
		
		if (checkChunk( data, "HIERARCHY" ) > -1) {
			hierarchy_toggle = true;
            motion_toggle = false;
		} else if (checkChunk( data, "MOTION" ) > -1) {
			hierarchy_toggle = false;
		}
		
		if (hierarchy_toggle) {
			if (checkChunk( data, "ROOT" ) > -1) {
                var index = checkChunk( data, "ROOT" );
                cur_name = data[index+1];
                cur_index++;
                if (boneCache[cur_index].getParameter("name") != cur_name) {
                    var res = OS.messageBox("Different bone name detected!", "You have to select root object of bone tree.\nDo you want force attaching BVH motion info to your selection?");
                    if (res == 0) return;
                }
            }
            if (checkChunk( data, "JOINT" ) > -1) {
                var index = checkChunk( data, "JOINT" );
                cur_name = data[index+1];
                cur_index++;
                if (boneCache[cur_index].getParameter("name") != cur_name) {
                    var res = OS.messageBox("Different bone name Detected!", "You have to select root object of bone tree.\nDo you want force attaching BVH motion info to your selection?");
                    if (res == 0) return;
                }
            }
            if (checkChunk( data, "CHANNELS" ) > -1) {
                var index = checkChunk( data, "CHANNELS" );
                var channelCount = parseInt(data[index+1]);
                for (var i = 0;i < channelCount;i++) {
                    var keyMatch = data[index+2+i].match(/([XYZ])rotation/);
                    if (keyMatch) {
                        var motionIndex = motionList.motionWithTargetAndKey( boneCache[ cur_index ], "rotation" );
                        if (motionIndex > -1) {
                            var motion = motionList[ motionIndex ];
                            motion.rotationOrder += keyMatch[1];
                        } else {
                            var motion = new Motion( boneCache[ cur_index ], "rotation" );
                            motion.rotationOrder += keyMatch[1];
                            motionList.push( motion );
                        }
                    } else {
                        var motion = new Motion( boneCache[ cur_index ], data[index+2+i] );
                        motionList.push( motion );
                    }
                }
                motionCount += parseInt(channelCount);
            }
		}
        
        if (motion_toggle && data.length == motionCount) {
            var dataIndex = 0;
            var len = motionList.length;
            var val, rot;
            for (var i = 0;i < len;i++) {
                var obj = motionList[i].target;
                var paramKey = motionList[i].key;
                var fCurveIndex = 0;
                
                var param;
                switch( paramKey ) {
                    case 'Xposition':
                        param = obj.parameterWithName("position");
                        fCurveIndex = 0;
                        val = parseFloat( data[dataIndex] ) * factor;
                        dataIndex++;
                        //print( motionList[i].target.getParameter("name") + '.x:' + val.toFixed(4) );
                        break;
                    case 'Yposition':
                        param = obj.parameterWithName("position");
                        fCurveIndex = 1;
                        val = parseFloat( data[dataIndex] ) * factor;
                        dataIndex++;
                        //print( motionList[i].target.getParameter("name") + '.y:' + val.toFixed(4) );
                        break;
                    case 'Zposition':
                        param = obj.parameterWithName("position");
                        fCurveIndex = 2;
                        val = parseFloat( data[dataIndex] ) * factor;
                        dataIndex++;
                        //print( motionList[i].target.getParameter("name") + '.z:' + val.toFixed(4) );
                        break;
                    case 'rotation':
                        param = obj.parameterWithName("rotation");
                        rot = new Vec3D();
                        for (var j = 0;j < motionList[i].rotationOrder.length;j++) {
                            switch( motionList[i].rotationOrder.charAt(j) ) {
                                case "X":
                                    rot.x = parseFloat( data[dataIndex] );
                                    dataIndex++;
                                    break;
                                case "Y":
                                    rot.y = parseFloat( data[dataIndex] );
                                    dataIndex++;
                                    break;
                                case "Z":
                                    rot.z = parseFloat( data[dataIndex] );
                                    dataIndex++;
                                    break;
                            }
                        }
                        //print( motionList[i].target.getParameter("name") + '.rotation:' + Vec3D_toString( rot ) );
                        break;
                }
                var takeNode = param.takeNodeWithName( currentTake.name );
                if (takeNode==null) {
                    takeNode = param.addTakeNode( currentTake.name );
                }
                if (takeNode) {
                    if (paramKey == "rotation") { // rotation parameter
                        
                        // create Mat4D from XYZ value, then getting  HPB ratation value for keying.
                        // thank you for Martin's help.:)
                        
                        /* old code for learning...
                        var mat = new Mat4D();
                        for (var j = 0;j < motionList[i].rotationOrder.length;j++) {
                            switch( motionList[i].rotationOrder.charAt(j) ) {
                                case "X":
                                    mat = mat.multiply( new Mat4D( ROTATE, rot.x, 0, 0 ) );
                                    break;
                                case "Y":
                                    mat = mat.multiply( new Mat4D( ROTATE, 0, rot.y, 0 ) );
                                    break;
                                case "Z":
                                    mat = mat.multiply( new Mat4D( ROTATE, 0, 0, rot.z ) );
                                    break;
                            }
                        }
                        
                        var rh, rp, rb;
                        rp = Math.asin( Math.max( -1.0, Math.min( 1.0, -mat.m12 ) ) );
                        if (Math.abs( Math.cos( rp ) ) > 0.0001) {
                            rh = Math.atan2( mat.m02, mat.m22 );
                            rb = Math.atan2( mat.m10, mat.m11 );
                        } else {
                            rh = Math.atan2( -mat.m20, mat.m00 );
                            rb = 0;
                        }
                         */
                        
                        var rotOrder;
                        switch( motionList[i].rotationOrder ) {
                            case 'ZYX':
                            case 'ZY':
                                rotOrder = ROT_XYZ;
                                break;
                            case 'YZX':
                            case 'YZ':
                                rotOrder = ROT_XZY;
                                break;
                            case 'XZY':
                            case 'XZ':
                                rotOrder = ROT_YZX;
                                break;
                            case 'ZXY':
                            case 'ZX':
                                rotOrder = ROT_YXZ;
                                break;
                            case 'YXZ':
                            case 'YX':
                                rotOrder = ROT_ZXY;
                                break;
                            case 'XYZ':
                            case 'XY':
                                rotOrder = ROT_ZYX;
                                break;
                            default: // only 1 rotation axis
                                rotOrder = ROT_XYZ;
                                break;
                        }
                        
                        if (rotationHints[ i ]) {
                            var rot = rot.convertEuler( rotOrder, ROT_HPB, rotationHints[ i ] );
                            rotationHints[ i ] = rot;
                        } else {
                            var rot = rot.convertEuler( rotOrder, ROT_HPB );
                            rotationHints[ i ] = rot;
                        }
                        
                        rotVal = [ rot.x, rot.y, rot.z ];
                        
                        for (var j = 0;j < 3;j++) {
                            var fCurve = takeNode.fCurveAtIndex( j );
                            
                            var key = new FCurveKey();
                            key.time = timeCurrent;
                            key.value = rotVal[ j ];
                            key.left_type = LINEAR_INTERPOL;
                            key.right_type = LINEAR_INTERPOL;
                            
                            fCurve.addKey( key );
                        }
                    } else { // position parameters
                        var fCurve = takeNode.fCurveAtIndex( fCurveIndex );
                        
                        var key = new FCurveKey();
                        key.time = timeCurrent;
                        key.value = val;
                        key.left_type = LINEAR_INTERPOL;
                        key.right_type = LINEAR_INTERPOL;
                        
                        fCurve.addKey( key );
                    }
                }
            }
            timeCurrent += timeFrame;
        }
        
        if (checkChunk( data, "Frame" ) > -1 && checkChunk( data, "Time:") > -1) {
            var index = checkChunk( data, "Time:" );
            timeFrame = parseFloat( data[index+1] );
            
            if (overwriteFps) {
                timeFrame = 1 / fps;
            }
            
            print('timeFrame:'+timeFrame);
            print('motionList:'+motionList);
            motion_toggle = true;
        }
        
		line = file.readln();
	}
}

function cacheObjectInfo( obj ) {
    
    if (obj.type() == 45) {
        boneCache.push( obj );
    }
    
    var len = obj.childCount();
    for( var i = 0;i < len;i++) {
        var child = obj.childAtIndex( i );
        
        if (child && child.getParameter("name") != 'Site') {
            cacheObjectInfo( child );
        }
    }
}

